/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.error;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.w3c.css.error.ErrorReport;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Util;
import org.xml.sax.SAXParseException;

public class ErrorReportHTML
extends ErrorReport {
    String title;
    Exception e;

    public ErrorReportHTML(ApplContext ac, String title, String output, Exception e) {
        this.title = title;
        this.e = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintWriter out) {
        try {
            URL localURL = ErrorReportHTML.class.getResource("error.html");
            DataInputStream in = new DataInputStream(localURL.openStream());
            try {
                while (true) {
                    out.print((char)in.readUnsignedByte());
                }
            }
            catch (EOFException eof) {
                out.println("<h2>Target: " + Util.escapeHTML(this.title) + "</h2>");
                out.println("<div class=\"error\">");
                if (this.e instanceof ResourceNotFoundException) {
                    out.println("<p>" + this.e.toString() + "</p>");
                } else if (this.e instanceof IOException) {
                    out.println("<p>I/O Error: ");
                    out.println(Util.escapeHTML(this.e.getMessage()));
                } else if (this.e instanceof SAXParseException) {
                    SAXParseException saxe = (SAXParseException)this.e;
                    out.println("<p>Please, validate your XML document first!</p>");
                    if (saxe.getLineNumber() != -1) {
                        out.print("<p>Line ");
                        out.print(saxe.getLineNumber());
                        out.println("</p>");
                    }
                    if (saxe.getColumnNumber() != -1) {
                        out.print("<p>Column ");
                        out.print(saxe.getColumnNumber());
                        out.print("</p>\n");
                    }
                    out.println("<p>" + Util.escapeHTML(this.e.getMessage()));
                } else if (this.e instanceof NullPointerException) {
                    out.println("<p>Oups! Internal error!</p><p>");
                    this.e.printStackTrace();
                } else {
                    out.println(this.e.toString());
                }
                out.println("</p></div>\n<hr />\n<p><img src='images/mwcss.gif' alt='made with CSS' /></p>\n<address><a href='Email.html'>www-validator-css</a></address>\n</body></html>");
                out.flush();
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception unknown) {
            if (out != null) {
                out.println("org.w3c.css.servlet.CssValidator: couldn't load  error file");
                out.flush();
            }
            unknown.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

